package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.kongqw.serialportlibrary.SerialPortManager;
import com.kongqw.serialportlibrary.listener.OnSerialPortDataListener;
import com.vf106.tools.R;
import com.vf106.tools.utils.Constants;

import java.io.File;

/**
 * Scanning through the serial port
 */
public class QrActivity extends AppCompatActivity implements View.OnClickListener {
    private static final String TAG = "QrActivity";
    private SerialPortManager mSerialPortManager;
    private TextView tv;
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_qr);
        initView();
        setListener();
    }

    private void initView() {
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
        tv = findViewById(R.id.tv);
        mSerialPortManager = new SerialPortManager();
        boolean openSerialPort = mSerialPortManager.openSerialPort(new File("/dev/ttyS8"), 115200);
        Log.i("openSerialPort", "openSerialPort： " + openSerialPort);
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);
    }

    private void setListener() {
        mSerialPortManager.startReadThread(0);
        mSerialPortManager.startSendThread();
        //Adding Data Communication Listening
        mSerialPortManager.setOnSerialPortDataListener(new OnSerialPortDataListener() {
            @Override
            public void onDataReceived(byte[] bytes) {
                runOnUiThread(() -> tv.setText(new String(bytes)));
            }

            @Override
            public void onDataSent(byte[] bytes) {
                Log.i(TAG, "onDataSent=====>" + new String(bytes));
            }
        });
        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mSerialPortManager.closeSerialPort();
    }
}
